ALTER TABLE "${schema}".scheduler ADD COLUMN schedulerType character varying(40) DEFAULT 'incrementalLoad';

ALTER TABLE "${schema}".synchronization RENAME COLUMN scheduler_id TO inc_scheduler_id;
ALTER TABLE "${schema}".synchronization ADD COLUMN full_scheduler_id bigint DEFAULT NULL;

ALTER TABLE "${schema}".synchronization
    ADD CONSTRAINT fk_full_load_scheduler
    FOREIGN KEY (full_scheduler_id)
    REFERENCES "${schema}".scheduler (id)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION;

drop view synchronizationview;

CREATE VIEW "${schema}".synchronizationview AS
SELECT sync.id,
    sync.manual,
    sync.waiting,
    sync.enabled,
    sync.name,
    (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.next_fire_time = -1 THEN null ELSE qrtz_incremental.next_fire_time END) AS nextIncrementalStartLong,
    (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or  qrtz_full.next_fire_time = -1 THEN null ELSE qrtz_full.next_fire_time END) AS nextFullStartLong,
    LEAST(
        (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.next_fire_time = -1 THEN null ELSE qrtz_incremental.next_fire_time END),
        (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or  qrtz_full.next_fire_time = -1 THEN null ELSE qrtz_full.next_fire_time END)
    ) AS nextStartLong,
    a.id AS lastLog_id,
    EXTRACT(EPOCH FROM (a.endDate - a.startDate)) * 1000 AS lastDuration
FROM synchronization sync 
    JOIN "${schema}".scheduler incrementalScheduler ON sync.inc_scheduler_id = incrementalScheduler.id
    LEFT JOIN "${schema}".scheduler fullScheduler ON sync.full_scheduler_id = fullScheduler.id
    LEFT JOIN "${schema}".QRTZ_TRIGGERS qrtz_incremental ON CONCAT('SyncId_', sync.id) = qrtz_incremental.TRIGGER_NAME
    LEFT JOIN "${schema}".activityLog a ON  a.id = (SELECT al.id FROM "${schema}".activityLog al WHERE al.synchronization = sync.id ORDER BY al.id DESC LIMIT 1)
    LEFT JOIN "${schema}".QRTZ_TRIGGERS qrtz_full ON CONCAT('CleanAndSync_SyncId_', sync.id) = qrtz_full.TRIGGER_NAME;

commit;
