/*
 * Decompiled with CFR 0.152.
 */
package com.snowMirror.upgrade;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;

public class FilesAndDirsDeletingVisitor
extends SimpleFileVisitor<Path> {
    private final Path dir;
    private final List<Path> exceptions;

    public FilesAndDirsDeletingVisitor(Path dir, List<Path> exceptions) {
        this.dir = dir;
        this.exceptions = exceptions;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path visitDir, BasicFileAttributes attrs) throws IOException {
        if (Files.isSameFile(visitDir, this.dir)) {
            return FileVisitResult.CONTINUE;
        }
        for (Path exc : this.exceptions) {
            if (!Files.isDirectory(exc, new LinkOption[0]) || !visitDir.startsWith(exc)) continue;
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        for (Path exc : this.exceptions) {
            if (Files.isDirectory(exc, new LinkOption[0]) || !Files.isSameFile(file, exc)) continue;
            return FileVisitResult.CONTINUE;
        }
        Files.deleteIfExists(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path d, IOException exc) throws IOException {
        if (exc != null) {
            throw exc;
        }
        for (Path ex : this.exceptions) {
            if (!Files.isDirectory(ex, new LinkOption[0]) || !Files.isSameFile(d, ex)) continue;
            return FileVisitResult.CONTINUE;
        }
        if (!Files.isSameFile(d, this.dir)) {
            Files.deleteIfExists(d);
        }
        return FileVisitResult.CONTINUE;
    }
}

