#!/bin/sh

# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -----------------------------------------------------------------------------
# Stop script for the CATALINA Server
#
# $Id: shutdown.sh 1202062 2011-11-15 06:50:02Z mturk $
# -----------------------------------------------------------------------------

# Better OS/400 detection: see Bugzilla 31132
os400=false
case "`uname`" in
OS400*) os400=true;;
esac

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ] ; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

PRGDIR=`dirname "$PRG"`/bin
EXECUTABLE=catalina.sh

# Check that target executable exists
if $os400; then
  # -x will Only work on the os400 if the files are:
  # 1. owned by the user
  # 2. owned by the PRIMARY group of the user
  # this will not work if the user belongs in secondary groups
  eval
else
  if [ ! -x "$PRGDIR"/"$EXECUTABLE" ]; then
    echo "Cannot find $PRGDIR/$EXECUTABLE"
    echo "The file is absent or does not have execute permission"
    echo "This file is needed to run this program"
    exit 1
  fi
fi

# Helper current directory variable, should be ROOT of installer
_curr=`cd "$PRGDIR/.." >/dev/null; pwd`

# Parse Tomcat Ports & Application Context
APP_PORT=`sed '/^\#/d' $_curr/snowMirror.properties | grep 'snowMirror.port'  | tail -n 1 | cut -d "=" -f2- | sed 's/^[[:space:]]*//;s/[[:space:]]*$//'`
CONTROL_PORT=`sed '/^\#/d' $_curr/snowMirror.properties | grep 'snowMirror.controlport'  | tail -n 1 | cut -d "=" -f2- | sed 's/^[[:space:]]*//;s/[[:space:]]*$//'`
APP_CONTEXT=`sed '/^\#/d' $_curr/snowMirror.properties | grep 'snowMirror.context'  | tail -n 1 | cut -d "=" -f2- | sed 's/^[[:space:]]*//;s/[[:space:]]*$//'`

export JAVA_OPTS="$JAVA_OPTS -Dtomcat.http.port=$APP_PORT -Dtomcat.http.controlport=$CONTROL_PORT -Dtomcat.snowMirror.context=$APP_CONTEXT $APP_JAVA_OPTS"

if [ "$#" -gt 0 ]; then
  exec "$PRGDIR"/"$EXECUTABLE" stop "$@"
else
  exec "$PRGDIR"/"$EXECUTABLE" stop 60
fi
