-- Alter table config
ALTER TABLE CONFIG ADD COLUMN COMMENT varchar DEFAULT NULL;
ALTER TABLE CONFIG ADD COLUMN ISDEFAULTVALUE BOOLEAN DEFAULT 1;

UPDATE CONFIG SET ISDEFAULTVALUE = 0;

-- Adding new permissions because we need to prevent non-administrators from being able to About:config page
insert into permission (id, permission_name) values (14, 'PERMISSION_ABOUT_CONFIG');
insert into role_permission (role_id, permission_id) values (1, 14);

-- We happened to have multiple 'PERMISSION' tables in sequence generator -> clean them
DELETE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION' AND SEQ_NEXT_VALUE = 8;
DELETE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION' AND SEQ_NEXT_VALUE = 12;
UPDATE SEQUENCE_TABLE_GENERATOR SET SEQ_NEXT_VALUE = 15 WHERE SEQ_TABLE_NAME = 'PERMISSION';

commit;
