DROP VIEW synchronizationView;

CREATE VIEW synchronizationView AS
  SELECT
        sync.id
      , sync.manual
      , CASEWHEN(qrtz.NEXT_FIRE_TIME < (SELECT DATEDIFF('second', timestamp '1970-01-01 00:00:00' , CURRENT_TIMESTAMP()) * 1000), 1, 0) as waiting
      , CASEWHEN(qrtzFired.minFiredTime is not null, 1, 0) as running
      , qrtzFired.minFiredTime as runningSinceLong
      , sync.enabled
      , sync.name
      , sync.mirrortablename
      , sync.deletetype
      , sync.snowtable_id
      , sync.created
      , sync.createdby
      , sync.updated
      , sync.updatedby
      , sync.includeinheritedcolumns
      , sync.autoSchemaUpdate
      , sync.referencefieldtype
      , sync.schedulerPriority
      , sync.mirror_db_id
      , CASEWHEN (incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME) as nextIncrementalStartLong
      , minNextFullStart.nextFullStartLong as nextFullStartLong
      , qrtz.NEXT_FIRE_TIME as nextStartLong
      , a.id AS lastLog_id
      , a.startDate AS lastStartDate
      , a.status AS lastStatus
      , a.insertedcount AS lastInsertedCount
      , a.updatedcount AS lastUpdatedCount
      , a.deletedcount AS lastDeletedCount
      , a.insertedcount + a.updatedcount + a.deletedcount AS lastTotal
      , TIMESTAMPDIFF(SECOND, a.startDate, a.endDate) * 1000 AS lastDuration
      , st.type AS snowtableType
      , st.userquery AS snowtableUserquery
      , incrementalScheduler.schedulerdefinitiontype AS incSchedulerDefinitionType
  FROM SYNCHRONIZATION AS sync
         JOIN SNOWTABLE st                        ON sync.snowtable_id = st.id
         JOIN SCHEDULER incrementalScheduler      ON sync.INC_SCHEDULER_ID = incrementalScheduler.ID
         LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and qrtz_incremental.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.ID, '_IncrementalLoad')) and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
         LEFT JOIN minNextFullStartView minNextFullStart ON sync.id = minNextFullStart.sync_id
         LEFT JOIN ACTIVITYLOG a                  ON sync.LASTLOG_ID = a.ID
         LEFT JOIN minFireTimeView qrtz           ON      qrtz.JOB_NAME = CONCAT('SyncId_', sync.id)
         LEFT JOIN minFiredTimeView qrtzFired     ON qrtzFired.JOB_NAME = CONCAT('SyncId_', sync.id);
