-- If customer already created this index manually, let's drop it so that the next
-- Flyway script that creates the index does not fail.
BEGIN TRY
    IF EXISTS (SELECT 1
               FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS
               WHERE CONSTRAINT_NAME = 'stg_tblname' AND TABLE_SCHEMA = '${schema}')
        BEGIN
            ALTER TABLE [${schema}].SEQUENCE_TABLE_GENERATOR
                DROP CONSTRAINT stg_tblname;
        END
END TRY
BEGIN CATCH
    PRINT 'Failed to drop index stg_tblname.'
END CATCH