CREATE VIEW [${schema}].[synchronizationView] AS
  SELECT
         sync.id
      , sync.manual
      , (CASE WHEN qrtz.NEXT_FIRE_TIME < ((SELECT CAST(DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()) as BIGINT) * 1000) + 1000) THEN 1 ELSE 0 END) as waiting
      , (CASE WHEN qrtzFired.minFiredTime IS NOT NULL THEN 1 ELSE 0 END) as running
      , sync.enabled
      , sync.name
      , sync.mirrorTableName
      , sync.deletetype
      , sync.snowTable_id
      , sync.created
      , sync.createdBy
      , sync.updated
      , sync.updatedBy
      , sync.includeInheritedColumns
      , sync.autoSchemaUpdate
      , sync.referenceFieldType
      , sync.schedulerPriority
      , (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) as nextIncrementalStartLong
      , (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) as nextFullStartLong
      , qrtz.NEXT_FIRE_TIME as nextStartLong
      , a.id AS lastLog_id
      , a.startDate AS lastStartDate
      , a.status AS lastStatus
      , a.insertedCount AS lastInsertedCount
      , a.updatedCount AS lastUpdatedCount
      , a.deletedCount AS lastDeletedCount
      , a.insertedCount + a.updatedCount + a.deletedCount AS lastTotal
      , DATEDIFF(SECOND, a.startDate, a.endDate) * 1000 AS lastDuration
      , st.type AS snowtableType
      , st.userQuery AS snowtableUserquery
      , incrementalScheduler.schedulerDefinitionType AS incSchedulerDefinitionType
      , fullScheduler.schedulerDefinitionType AS fullSchedulerDefinitionType
      , fullScheduler.executionType AS fullSchedulerExecutionType
  FROM [${schema}].[synchronization] sync
         JOIN [${schema}].[snowTable] st                      ON sync.snowTable_id = st.id
         JOIN [${schema}].[scheduler] incrementalScheduler    ON sync.inc_scheduler_id = incrementalScheduler.id
         LEFT JOIN [${schema}].[scheduler] fullScheduler      ON sync.full_scheduler_id = fullScheduler.id
         LEFT JOIN [${schema}].QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and qrtz_incremental.TRIGGER_NAME = 'SyncId_' + CAST(sync.id AS VARCHAR(50)) + '_IncrementalLoad' and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
         LEFT JOIN [${schema}].QRTZ_TRIGGERS qrtz_full        ON        qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and        qrtz_full.TRIGGER_NAME = 'SyncId_' + CAST(sync.id AS VARCHAR(50)) + '_FullLoad'        and        qrtz_full.TRIGGER_GROUP = 'DEFAULT'
         LEFT JOIN [${schema}].[activityLog] a                ON sync.lastLog_id = a.id
         LEFT JOIN [${schema}].minFireTimeView qrtz           ON      qrtz.JOB_NAME = 'SyncId_' + CAST(sync.id AS VARCHAR(50))
         LEFT JOIN [${schema}].minFiredTimeView qrtzFired     ON qrtzFired.JOB_NAME = 'SyncId_' + CAST(sync.id AS VARCHAR(50));
