ALTER TABLE [${schema}].[activityLog] WITH CHECK ADD CONSTRAINT [fk_activityDataStorage_id] FOREIGN KEY([activityDataStorage_id]) REFERENCES [${schema}].[dataStorage]([id]);
ALTER TABLE [${schema}].[activityLog] WITH CHECK ADD CONSTRAINT [fk_resumeDataStorage_id] FOREIGN KEY([resumeDataStorage_id]) REFERENCES [${schema}].[dataStorage]([id]);

INSERT INTO [${schema}].[dataStorage] ([id], [data]) (
    SELECT [id], [resumeState] as [data]
    FROM [${schema}].[activityLog]
    WHERE [status] = 'FAILED'
          AND [resumeState] IS NOT NULL
);

INSERT INTO [${schema}].SEQUENCE_TABLE_GENERATOR (SEQ_TABLE_NAME, SEQ_NEXT_VALUE)
VALUES ('DATA_STORAGE', COALESCE((SELECT (MAX([id]) + 11) from [${schema}].[dataStorage]), 0));

ALTER TABLE [${schema}].[activityLog]
    DROP COLUMN [resumeState], [resumeStateString];
