-- Resetting sequence generator values after migration to Hibernate 6
-- The sequence for every table has to be reset to <max id value of table> + 1 + <allocation size>
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[role]) WHERE [SEQ_TABLE_NAME] = 'ROLE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[users]) WHERE [SEQ_TABLE_NAME] = 'USER';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[permission]) WHERE [SEQ_TABLE_NAME] = 'PERMISSION';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[mirrorTable]) WHERE [SEQ_TABLE_NAME] = 'MIRROR_TABLE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[dataStorage]) WHERE [SEQ_TABLE_NAME] = 'DATA_STORAGE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[config]) WHERE [SEQ_TABLE_NAME] = 'CONFIG';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[clusterNode]) WHERE [SEQ_TABLE_NAME] = 'CLUSTER_NODE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[auditEventLog]) WHERE [SEQ_TABLE_NAME] = 'AUDIT_EVENT_LOG';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[license]) WHERE [SEQ_TABLE_NAME] = 'LICENSE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[asyncNotification]) WHERE [SEQ_TABLE_NAME] = 'ASYNC_NOTIFICATION';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[asyncNotificationMessage]) WHERE [SEQ_TABLE_NAME] = 'ASYNC_NOTIFICATION_MESSAGE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[synchronization]) WHERE [SEQ_TABLE_NAME] = 'SYNCHRONIZATION';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[snowTable]) WHERE [SEQ_TABLE_NAME] = 'SNOW_TABLE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[snowColumn]) WHERE [SEQ_TABLE_NAME] = 'SNOW_COLUMN';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[columnMapping]) WHERE [SEQ_TABLE_NAME] = 'TYPE_MAPPING';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[scheduler]) WHERE [SEQ_TABLE_NAME] = 'SCHEDULER';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[sncPlugin]) WHERE [SEQ_TABLE_NAME] = 'SNC_PLUGIN_QUEUE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[activityLog]) WHERE [SEQ_TABLE_NAME] = 'ACTIVITY_LOG';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[statsCount]) WHERE [SEQ_TABLE_NAME] = 'STATS_COUNT';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[syncOption]) WHERE [SEQ_TABLE_NAME] = 'SYNCOPTION';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[tableRotationGroup]) WHERE [SEQ_TABLE_NAME] = 'TABLE_ROTATION_GROUP';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 1 as seq_next_value FROM [${schema}].[tableRotationSchedule]) WHERE [SEQ_TABLE_NAME] = 'TABLE_ROTATION_SCHEDULE';
UPDATE [${schema}].[SEQUENCE_TABLE_GENERATOR] SET [SEQ_NEXT_VALUE] = (SELECT COALESCE((max([id]) + 1), 1) + 10 as seq_next_value FROM [${schema}].[syncOption]) WHERE [SEQ_TABLE_NAME] = 'SNOW_INDEX';