CREATE TABLE `permission` (
  `id` bigint NOT NULL,
  `permission_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `role` (
  `id` bigint NOT NULL,
  `role_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `users` (
  `id` bigint NOT NULL,
  `active` tinyint NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `username` varchar(190) DEFAULT NULL,
  `timezone` VARCHAR(255) DEFAULT 'Europe/Prague',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username_` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `role_permission` (
  `role_id` bigint NOT NULL,
  `permission_id` bigint NOT NULL,
  KEY `FKBD40D5385E18A62B` (`permission_id`),
  KEY `FKBD40D53860B59A0B` (`role_id`),
  CONSTRAINT `FKBD40D53860B59A0B` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`),
  CONSTRAINT `FKBD40D5385E18A62B` FOREIGN KEY (`permission_id`) REFERENCES `permission` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `user_role` (
  `users_id` bigint NOT NULL,
  `roles_id` bigint NOT NULL,
  KEY `FK143BF46AFECE1264` (`roles_id`),
  KEY `FK143BF46A546A2CE` (`users_id`),
  CONSTRAINT `FK143BF46A546A2CE` FOREIGN KEY (`users_id`) REFERENCES `users` (`id`),
  CONSTRAINT `FK143BF46AFECE1264` FOREIGN KEY (`roles_id`) REFERENCES `role` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;





CREATE TABLE `scheduler` (
  `id` bigint NOT NULL,
  `cronExpression` varchar(255) DEFAULT NULL,
  `dayOfMonth` int DEFAULT NULL,
  `dayOfYear` int DEFAULT NULL,
  `daysOfWeek` int DEFAULT NULL,
  `hour` int DEFAULT NULL,
  `minute` int DEFAULT NULL,
  `period` int DEFAULT NULL,
  `schedulerDefinitionType` varchar(255) DEFAULT NULL,
  `second` int DEFAULT NULL,
  `startDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;



CREATE TABLE `snowTable` (
  `id` bigint NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `prefix` varchar(255) DEFAULT NULL,
  `sysId` varchar(255) DEFAULT NULL,
  `userQuery` varchar(1000) DEFAULT NULL,
  `hasUpdatedOnColumn` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;



CREATE TABLE `synchronization` (
  `id` bigint NOT NULL,
  `created` datetime DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `enabled` tinyint NOT NULL,
  `manual` tinyint NOT NULL,
  `mirrorTableName` varchar(190) NOT NULL,
  `name` varchar(190) NOT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedBy` varchar(255) DEFAULT NULL,
  `deleteType` varchar(255) NOT NULL,
  `waiting` tinyint NOT NULL,
  `scheduler_id` bigint DEFAULT NULL,
  `snowTable_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mirrorTableName_` (`mirrorTableName`),
  UNIQUE KEY `name_` (`name`),
  KEY `FK4F99F26092C0842D` (`scheduler_id`),
  KEY `FK4F99F260CF389574` (`snowTable_id`),
  CONSTRAINT `FK4F99F260CF389574` FOREIGN KEY (`snowTable_id`) REFERENCES `snowTable` (`id`),
  CONSTRAINT `FK4F99F26092C0842D` FOREIGN KEY (`scheduler_id`) REFERENCES `scheduler` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;


CREATE TABLE `snowObject` (
  `type` varchar(31) NOT NULL,
  `id` bigint NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sysId` varchar(255) DEFAULT NULL,
  `userQuery` varchar(1000) DEFAULT NULL,
  `syncTableSysId` varchar(255) DEFAULT NULL,
  `prefix` varchar(255) DEFAULT NULL,
  `snowviewtable_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FKA07312A21C75BFC8` (`snowviewtable_id`),
  CONSTRAINT `FKA07312A21C75BFC8` FOREIGN KEY (`snowviewtable_id`) REFERENCES `snowObject` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;


CREATE TABLE `snowColumn` (
  `id` bigint NOT NULL,
  `length` int DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sysId` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `snowtable_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK8CB142B9CF389574` (`snowtable_id`),
  CONSTRAINT `FK8CB142B9CF389574` FOREIGN KEY (`snowtable_id`) REFERENCES `snowTable` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;


CREATE TABLE `SEQUENCE_TABLE_GENERATOR` (
  `SEQ_TABLE_NAME` varchar(255) DEFAULT NULL,
  `SEQ_NEXT_VALUE` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `activityLog` (
  `id` bigint NOT NULL,
  `deletedCount` int DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `insertedCount` int DEFAULT NULL,
  `logs` longtext,
  `startDate` datetime DEFAULT NULL,
  `startedBy` varchar(255) DEFAULT NULL,
  `status` varchar(190) DEFAULT NULL,
  `totalToDelete` int DEFAULT NULL,
  `totalToInsert` int DEFAULT NULL,
  `totalToUpdate` int DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `updatedCount` int DEFAULT NULL,
  `synchronization` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FKC95329B59398B953` (`synchronization`),
  CONSTRAINT `FKC95329B59398B953` FOREIGN KEY (`synchronization`) REFERENCES `synchronization` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `notification` (
  `id` bigint NOT NULL,
  `notificationReceiver` varchar(255) DEFAULT NULL,
  `notificationType` varchar(255) DEFAULT NULL,
  `synchronization_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK237A88EB8FF4AA4D` (`synchronization_id`),
  CONSTRAINT `FK237A88EB8FF4AA4D` FOREIGN KEY (`synchronization_id`) REFERENCES `synchronization` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;
