
  CREATE TABLE "ROLE" (
    "ID" NUMBER(19,0) NOT NULL ENABLE, 
	"ROLE_NAME" VARCHAR2(255 CHAR), 
	 PRIMARY KEY ("ID")
   );

  CREATE TABLE "PERMISSION" (
    "ID" NUMBER(19,0) NOT NULL ENABLE, 
	"PERMISSION_NAME" VARCHAR2(255 CHAR), 
	 PRIMARY KEY ("ID")
   );

  CREATE TABLE "ROLE_PERMISSION" (	
    "ROLE_ID" NUMBER(19,0) NOT NULL ENABLE, 
	"PERMISSION_ID" NUMBER(19,0) NOT NULL ENABLE, 
	 CONSTRAINT "FKBD40D5385E18A62B" FOREIGN KEY ("PERMISSION_ID")
	  REFERENCES "PERMISSION" ("ID") ENABLE, 
	 CONSTRAINT "FKBD40D53860B59A0B" FOREIGN KEY ("ROLE_ID")
	  REFERENCES "ROLE" ("ID") ENABLE
   );

  CREATE TABLE "USERS"  (
    "ID" NUMBER(19,0) NOT NULL ENABLE, 
	"ACTIVE" NUMBER(1,0) NOT NULL ENABLE, 
	"PASSWORD" VARCHAR2(255 CHAR), 
	"USERNAME" VARCHAR2(255 CHAR),
	"TIMEZONE" VARCHAR2(255) DEFAULT 'Europe/Prague',
	 PRIMARY KEY ("ID")
   );
   
  CREATE TABLE "USER_ROLE" (
    "USERS_ID" NUMBER(19,0) NOT NULL ENABLE, 
	"ROLES_ID" NUMBER(19,0) NOT NULL ENABLE, 
	 CONSTRAINT "FK143BF46AFECE1264" FOREIGN KEY ("ROLES_ID")
	  REFERENCES "ROLE" ("ID") ENABLE, 
	 CONSTRAINT "FK143BF46A546A2CE" FOREIGN KEY ("USERS_ID")
	  REFERENCES "USERS" ("ID") ENABLE
   );


  CREATE TABLE "SEQUENCE_TABLE_GENERATOR" (
    "SEQ_TABLE_NAME" VARCHAR2(255 CHAR), 
	"SEQ_NEXT_VALUE" NUMBER(10,0)
   ) ;
   
  CREATE TABLE "SNOWTABLE" 
   (	"ID" NUMBER(19,0) NOT NULL ENABLE, 
	"HASUPDATEDONCOLUMN" NUMBER(1,0) NOT NULL ENABLE, 
	"NAME" VARCHAR2(255 CHAR), 
	"PREFIX" VARCHAR2(255 CHAR), 
	"SYSID" VARCHAR2(255 CHAR), 
	"USERQUERY" VARCHAR2(1000 CHAR), 
	 PRIMARY KEY ("ID")
   ) ;
 
  CREATE TABLE "SCHEDULER" 
   (	"ID" NUMBER(19,0) NOT NULL ENABLE, 
	"CRONEXPRESSION" VARCHAR2(255 CHAR), 
	"DAYOFMONTH" NUMBER(10,0), 
	"DAYOFYEAR" NUMBER(10,0), 
	"DAYSOFWEEK" NUMBER(10,0), 
	"HOUR" NUMBER(10,0), 
	"MINUTE" NUMBER(10,0), 
	"PERIOD" NUMBER(10,0), 
	"SCHEDULERDEFINITIONTYPE" VARCHAR2(255 CHAR), 
	"SECOND" NUMBER(10,0), 
	"STARTDATE" DATE, 
	 PRIMARY KEY ("ID")
   ) ;
   
  CREATE TABLE "SYNCHRONIZATION" 
   (	"ID" NUMBER(19,0) NOT NULL ENABLE, 
	"CREATED" TIMESTAMP (6), 
	"CREATEDBY" VARCHAR2(255 CHAR), 
	"ENABLED" NUMBER(1,0) NOT NULL ENABLE, 
	"MANUAL" NUMBER(1,0) NOT NULL ENABLE, 
	"MIRRORTABLENAME" VARCHAR2(255 CHAR) NOT NULL ENABLE, 
	"DELETETYPE" VARCHAR2(255 CHAR) NOT NULL ENABLE,
	"NAME" VARCHAR2(255 CHAR) NOT NULL ENABLE, 
	"UPDATED" TIMESTAMP (6), 
	"UPDATEDBY" VARCHAR2(255 CHAR), 
	"WAITING" NUMBER(1,0) NOT NULL ENABLE, 
	"SCHEDULER_ID" NUMBER(19,0), 
	"SNOWTABLE_ID" NUMBER(19,0), 
	 PRIMARY KEY ("ID"), 
	 CONSTRAINT "FK4F99F26092C0842D" FOREIGN KEY ("SCHEDULER_ID")
	  REFERENCES "SCHEDULER" ("ID") ENABLE, 
	 CONSTRAINT "FK4F99F260CF389574" FOREIGN KEY ("SNOWTABLE_ID")
	  REFERENCES "SNOWTABLE" ("ID") ENABLE
   );
 


  CREATE TABLE "SNOWCOLUMN" 
   (	"ID" NUMBER(19,0) NOT NULL ENABLE, 
	"LENGTH" NUMBER(10,0), 
	"NAME" VARCHAR2(255 CHAR), 
	"SYSID" VARCHAR2(255 CHAR), 
	"TYPE" VARCHAR2(255 CHAR), 
	"SNOWTABLE_ID" NUMBER(19,0), 
	 PRIMARY KEY ("ID"),
	 CONSTRAINT "FK8CB142B9CF389574" FOREIGN KEY ("SNOWTABLE_ID")
	  REFERENCES "SNOWTABLE" ("ID") ENABLE
   ) ;
 
  CREATE TABLE "NOTIFICATION" 
   (	"ID" NUMBER(19,0) NOT NULL ENABLE, 
	"NOTIFICATIONRECEIVER" VARCHAR2(255 CHAR), 
	"NOTIFICATIONTYPE" VARCHAR2(255 CHAR), 
	"SYNCHRONIZATION_ID" NUMBER(19,0), 
	 PRIMARY KEY ("ID"), 
	 CONSTRAINT "FK237A88EB8FF4AA4D" FOREIGN KEY ("SYNCHRONIZATION_ID")
	  REFERENCES "SYNCHRONIZATION" ("ID") ENABLE
   )  ;
 

  CREATE TABLE "ACTIVITYLOG" (	"ID" NUMBER(19,0) NOT NULL ENABLE, 
	"DELETEDCOUNT" NUMBER(10,0), 
	"ENDDATE" TIMESTAMP (6), 
	"INSERTEDCOUNT" NUMBER(10,0), 
	"LOGS" CLOB, 
	"STARTDATE" TIMESTAMP (6), 
	"STARTEDBY" VARCHAR2(255 CHAR), 
	"STATUS" VARCHAR2(255 CHAR), 
	"TOTALTODELETE" NUMBER(10,0), 
	"TOTALTOINSERT" NUMBER(10,0), 
	"TOTALTOUPDATE" NUMBER(10,0), 
	"TYPE" VARCHAR2(255 CHAR), 
	"UPDATEDCOUNT" NUMBER(10,0), 
	"SYNCHRONIZATION" NUMBER(19,0), 
	 PRIMARY KEY ("ID"), 
	 CONSTRAINT "FKC95329B59398B953" FOREIGN KEY ("SYNCHRONIZATION")
	  REFERENCES "SYNCHRONIZATION" ("ID") ENABLE
   );
 


 

 
