CREATE TABLE "MIRRORTABLE" (
  "ID" NUMBER(19,0) NOT NULL,
  "NAME" VARCHAR2(255 CHAR) NOT NULL,
  "TMPNAME" VARCHAR2(255 CHAR),
  "SHARDSCHEDULESYSID" VARCHAR2(32 CHAR),
  "SYNC_ID" NUMBER(19,0) NOT NULL,
  CONSTRAINT "PK_MIRR_TBL_ID" PRIMARY KEY ("ID"),
  CONSTRAINT "FK_MIRR_TBL_SYNC_ID" FOREIGN KEY ("SYNC_ID") REFERENCES "SYNCHRONIZATION"("ID")
);

CREATE TABLE "TABLEROTATIONGROUP" (
  "ID" NUMBER(19,0) NOT NULL,
  "ROTATIONTYPE" VARCHAR2(20 CHAR) NOT NULL,
  CONSTRAINT "PK_ROTGR_ID" PRIMARY KEY ("ID")
);

CREATE TABLE "TABLEROTATIONSCHEDULE" (
  "ID" NUMBER(19,0) NOT NULL,
  "SYSID" VARCHAR2(32 CHAR) NOT NULL,
  "TABLENAME" VARCHAR2(255 CHAR) NOT NULL,
  "VALIDFROM" TIMESTAMP(6),
  "VALIDTO" TIMESTAMP(6),
  "ISOFFLINE" NUMBER(1,0) DEFAULT 0 NOT NULL,
  "ROTATIONGROUP_ID" NUMBER(19,0) NOT NULL,
  PRIMARY KEY ("ID"),
  CONSTRAINT "FK_TRS_ROTATIONGROUP_ID" FOREIGN KEY ("ROTATIONGROUP_ID") REFERENCES "TABLEROTATIONGROUP" (ID)
);

CREATE INDEX "TBL_ROT_SCHED_TBLNAME" ON "TABLEROTATIONSCHEDULE"("TABLENAME");

INSERT INTO "MIRRORTABLE"("ID", "NAME", "TMPNAME", "SYNC_ID") (
  SELECT ROWNUM, s."MIRRORTABLENAME" as "NAME", s."TMPMIRRORTABLENAME" as "TMPNAME", s."ID" as "SYNC_ID"
  FROM "SYNCHRONIZATION" s
  WHERE s."MIRRORTABLENAME" IS NOT NULL
);

INSERT INTO "SEQUENCE_TABLE_GENERATOR" ("SEQ_TABLE_NAME", "SEQ_NEXT_VALUE") VALUES ('MIRROR_TABLE', (SELECT (COALESCE(MAX("ID"), 0)) + 1 FROM "MIRRORTABLE"));

ALTER TABLE "SYNCHRONIZATION" ADD "ROTATION" VARCHAR2(20 CHAR) DEFAULT 'DISABLED' NOT NULL;
ALTER TABLE "SYNCHRONIZATION" ADD "ROTATIONGROUP_ID" NUMBER(19,0);
ALTER TABLE "SYNCHRONIZATION" ADD CONSTRAINT "FK_ROTATION_ID" FOREIGN KEY ("ROTATIONGROUP_ID") REFERENCES "TABLEROTATIONGROUP"("ID");
