CREATE TABLE DATASTORAGE
(
    ID           BIGINT NOT NULL,
    DATA         TEXT,
    DATAASSTRING TEXT,
    PRIMARY KEY (ID)
);

ALTER TABLE ACTIVITYLOG ADD COLUMN (ACTIVITYDATASTORAGE_ID BIGINT, RESUMEDATASTORAGE_ID BIGINT);

ALTER TABLE ACTIVITYLOG
    ADD CONSTRAINT FK_ACTIVITYDATASTORAGE_ID FOREIGN KEY (ACTIVITYDATASTORAGE_ID) REFERENCES DATASTORAGE (ID);
ALTER TABLE ACTIVITYLOG
    ADD CONSTRAINT FK_RESUMEDATASTORAGE_ID FOREIGN KEY (RESUMEDATASTORAGE_ID) REFERENCES DATASTORAGE (ID);

INSERT INTO DATASTORAGE (ID, DATAASSTRING)
SELECT ID, RESUMESTATE as DATAASSTRING
FROM ACTIVITYLOG
WHERE STATUS = 'FAILED'
  AND RESUMESTATE IS NOT NULL;

INSERT INTO SEQUENCE_TABLE_GENERATOR(SEQ_TABLE_NAME, SEQ_NEXT_VALUE)
VALUES ('DATA_STORAGE', COALESCE((SELECT (MAX(ID) + 11) from DATASTORAGE), 0));

ALTER TABLE ACTIVITYLOG
    DROP COLUMN RESUMESTATE;
ALTER TABLE ACTIVITYLOG
    DROP COLUMN RESUMESTATESTRING;