ALTER VIEW [${schema}].[synchronizationView] AS
SELECT sync.id,
	sync.manual,
	sync.waiting,
	sync.enabled,
	sync.name,
	(CASE NEXT_FIRE_TIME WHEN -1 THEN null ELSE NEXT_FIRE_TIME END) AS nextStartLong,
	a.id AS lastLog_id,
	DATEDIFF(SECOND, startDate, endDate) * 1000 AS lastDuration
FROM synchronization sync 
	LEFT JOIN [${schema}].[QRTZ_TRIGGERS] ON 'SyncId_' + CAST(sync.id AS VARCHAR(50)) = QRTZ_TRIGGERS.TRIGGER_NAME
	LEFT JOIN [${schema}].[activityLog] a ON  a.id = (SELECT top(1) al.id FROM [${schema}].[activityLog] al WHERE al.synchronization = sync.id ORDER BY al.id DESC)