-- Recreates all views and configures "SQL Security" to "Invoker".

DROP VIEW minFireTimeView;
CREATE SQL SECURITY INVOKER VIEW minFireTimeView AS
SELECT   JOB_NAME, MIN(NEXT_FIRE_TIME) as NEXT_FIRE_TIME
FROM     QRTZ_TRIGGERS
WHERE    SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0'
  AND NEXT_FIRE_TIME > 0
  AND (TRIGGER_STATE = 'WAITING' OR TRIGGER_STATE = 'ACQUIRED' OR TRIGGER_STATE = 'BLOCKED')
GROUP BY JOB_NAME;



DROP VIEW minFiredTimeView;
CREATE SQL SECURITY INVOKER VIEW minFiredTimeView AS
SELECT   JOB_NAME, MIN(FIRED_TIME) as minFiredTime
FROM     QRTZ_FIRED_TRIGGERS
WHERE    SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0'
GROUP BY JOB_NAME;



DROP VIEW minNextFullStartView;
CREATE SQL SECURITY INVOKER VIEW minNextFullStartView AS
SELECT   sync.id as sync_id, MIN(IF (fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1, NULL, qrtz_full.NEXT_FIRE_TIME)) as nextFullStartLong
FROM     synchronization sync
             LEFT JOIN scheduler fullScheduler      ON fullScheduler.sync_id = sync.id
             LEFT JOIN QRTZ_TRIGGERS qrtz_full        ON        qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and        qrtz_full.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.id, CONCAT('_SchedulerId_', CONCAT(fullScheduler.id, '_AdditionalSchedulerLoad'))))        and        qrtz_full.TRIGGER_GROUP = 'DEFAULT'
GROUP BY sync.id;



DROP VIEW `activityLogView`;
CREATE SQL SECURITY INVOKER VIEW `activityLogView` AS
SELECT
    `al`.`id`
     , `al`.`synchronization`
     , `al`.`type`
     , `al`.`startedBy`
     , `al`.`scheduledStart`
     , `al`.`startDate`
     , `al`.`endDate`
     , `al`.`status`
     , `al`.`migrationStatus`
     , `al`.`insertedCount`
     , `al`.`updatedCount`
     , `al`.`deletedCount`
     , `al`.`totalToInsert`
     , `al`.`totalToUpdate`
     , `al`.`totalToDelete`
     , (`al`.`insertedCount` + `al`.`updatedCount` + `al`.`deletedCount`) AS `total`
     , `al`.`recordsCounted`
     , `al`.`totalKeysForDiff`
     , `al`.`keysForDiffDownloaded`
     , (timestampdiff(SECOND,`al`.`startDate`,`al`.`endDate`) * 1000) AS `duration`
     , st.`type` as snowtableType
FROM
    `activityLog` `al`
        JOIN `synchronization` sync ON `al`.`synchronization` = `sync`.`id`
        JOIN snowTable st ON sync.snowtable_id = st.id;



DROP VIEW synchronizationView;
CREATE SQL SECURITY INVOKER VIEW synchronizationView AS
SELECT
    sync.id
     , sync.manual
     , COALESCE((qrtz.NEXT_FIRE_TIME < ((UNIX_TIMESTAMP() * 1000) + 1000)), false) as waiting
     , (CASE WHEN qrtzFired.minFiredTime IS NOT NULL THEN true ELSE false END) as running
     , qrtzFired.minFiredTime as runningSinceLong
     , sync.enabled
     , sync.name
     , sync.mirrortablename
     , sync.deletetype
     , sync.snowtable_id
     , sync.created
     , sync.createdby
     , sync.updated
     , sync.updatedby
     , sync.includeinheritedcolumns
     , sync.autoSchemaUpdate
     , sync.referencefieldtype
     , sync.schedulerPriority
     , sync.mirror_db_id
     , sync.mirror_fs_id
     , sync.workflow
     , IF (incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME) as nextIncrementalStartLong
     , minNextFullStart.nextFullStartLong as nextFullStartLong
     , qrtz.NEXT_FIRE_TIME as nextStartLong
     , a.id AS lastLog_id
     , a.startDate AS lastStartDate
     , a.status AS lastStatus
     , a.insertedcount AS lastInsertedCount
     , a.updatedcount AS lastUpdatedCount
     , a.deletedcount AS lastDeletedCount
     , a.insertedcount + a.updatedcount + a.deletedcount AS lastTotal
     , TIMESTAMPDIFF(SECOND, a.startDate, a.endDate) * 1000 AS lastDuration
     , st.type AS snowtableType
     , st.userquery AS snowtableUserquery
     , incrementalScheduler.schedulerdefinitiontype AS incSchedulerDefinitionType
FROM synchronization AS sync
         JOIN snowTable st                        ON sync.snowtable_id = st.id
         JOIN scheduler incrementalScheduler      ON sync.inc_scheduler_id = incrementalScheduler.id
         LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and qrtz_incremental.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.id, '_IncrementalLoad')) and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
         LEFT JOIN minNextFullStartView minNextFullStart ON sync.id = minNextFullStart.sync_id
         LEFT JOIN activityLog a                  ON sync.lastLog_id = a.id
         LEFT JOIN minFireTimeView qrtz           ON      qrtz.JOB_NAME = CONCAT('SyncId_', sync.id)
         LEFT JOIN minFiredTimeView qrtzFired     ON qrtzFired.JOB_NAME = CONCAT('SyncId_', sync.id);