-- Add new permissions
INSERT INTO permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC');

INSERT INTO permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE + 1 FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL');

INSERT INTO permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE + 2 FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF');

INSERT INTO permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE + 3 FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM');

UPDATE SEQUENCE_TABLE_GENERATOR
SET SEQ_NEXT_VALUE = SEQ_NEXT_VALUE + 4
WHERE SEQ_TABLE_NAME = 'PERMISSION';

DELETE
FROM role_permission
WHERE permission_id = (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE');

DELETE
FROM permission
WHERE permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE';

INSERT INTO role_permission(role_id, permission_id)
VALUES ((SELECT r.id FROM role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC')),
       ((SELECT r.id FROM role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL')),
       ((SELECT r.id FROM role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF')),
       ((SELECT r.id FROM role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM')),

       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC')),
       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL')),
       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF')),
       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM')),

       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC')),
       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL')),
       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF')),
       ((SELECT r.id FROM role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM'));