CREATE OR REPLACE VIEW synchronizationView AS
  SELECT
        sync.id
      , sync.manual
      , (CASE WHEN qrtz.NEXT_FIRE_TIME < ((-- what follows is current unix timestamp
                                              EXTRACT(DAY FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))*86400
                                                + EXTRACT(HOUR FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))*3600
                                                + EXTRACT(MINUTE FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))*60
                                                + EXTRACT(SECOND FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))
                                              ) * 1000 + 1000) THEN 1 ELSE 0 END) as waiting
      , (CASE WHEN qrtzFired.minFiredTime IS NOT NULL THEN 1 ELSE 0 END) as running
      , qrtzFired.minFiredTime as runningSinceLong
      , sync.enabled
      , sync.name
      , sync.mirrortablename
      , sync.deletetype
      , sync.snowtable_id
      , sync.created
      , sync.createdby
      , sync.updated
      , sync.updatedby
      , sync.includeinheritedcolumns
      , sync.autoSchemaUpdate
      , sync.referencefieldtype
      , sync.schedulerPriority
      , (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL ELSE qrtz_incremental.NEXT_FIRE_TIME END) AS nextIncrementalStartLong
      , minNextFullStart.nextFullStartLong as nextFullStartLong
      , qrtz.NEXT_FIRE_TIME as nextStartLong
      , a.id AS lastLog_id
      , a.startDate AS lastStartDate
      , a.status AS lastStatus
      , a.insertedcount AS lastInsertedCount
      , a.updatedcount AS lastUpdatedCount
      , a.deletedcount AS lastDeletedCount
      , a.insertedcount + a.updatedcount + a.deletedcount AS lastTotal
      , (CAST(a.endDate AS DATE) - CAST(a.startDate AS DATE)) * 24 * 60 * 60 * 1000 AS lastDuration
      , st.type AS snowtableType
      , st.userquery AS snowtableUserquery
      , incrementalScheduler.schedulerdefinitiontype AS incSchedulerDefinitionType
  FROM "SYNCHRONIZATION" sync
         JOIN "SNOWTABLE" st                      ON sync.snowtable_id = st.id
         JOIN "SCHEDULER" incrementalScheduler    ON sync.inc_scheduler_id = incrementalScheduler.id
         LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and qrtz_incremental.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.id, '_IncrementalLoad')) and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
         LEFT JOIN minNextFullStartView minNextFullStart ON sync.id = minNextFullStart.sync_id
         LEFT JOIN "ACTIVITYLOG" a                ON sync.lastLog_id = a.id
         LEFT JOIN minFireTimeView qrtz           ON      qrtz.JOB_NAME = CONCAT('SyncId_', sync.id)
         LEFT JOIN minFiredTimeView qrtzFired     ON qrtzFired.JOB_NAME = CONCAT('SyncId_', sync.id);
