CREATE TABLE "${schema}".mirrorTable (
  id bigint NOT NULL,
  name character varying(255) NOT NULL,
  tmpName character varying(255),
  shardScheduleSysId character varying(32),
  validFrom TIMESTAMP WITHOUT TIME ZONE,
  validTo TIMESTAMP WITHOUT TIME ZONE,
  sync_id bigint,
  PRIMARY KEY (id),
  CONSTRAINT fk_mirr_tbl_sync_id FOREIGN KEY (sync_id) REFERENCES "${schema}".synchronization(id)
);

CREATE TABLE "${schema}".tableRotationGroup (
  id bigint NOT NULL,
  rotationType character varying(20) NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE "${schema}".tableRotationSchedule (
  id bigint NOT NULL,
  sysId character varying(32) NOT NULL,
  tableName character varying(255) NOT NULL,
  validFrom TIMESTAMP WITHOUT TIME ZONE,
  validTo TIMESTAMP WITHOUT TIME ZONE,
  isoffline boolean DEFAULT false NOT NULL,
  rotationGroup_id bigint NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT FK_TRS_ROTATIONGROUP_ID FOREIGN KEY (rotationGroup_id) REFERENCES "${schema}".tableRotationGroup (id)
);

INSERT INTO "${schema}".mirrorTable(id, name, tmpName, sync_id) (
  SELECT row_number() OVER() as id, s.mirrorTableName as name, s.tmpMirrorTableName as tmpName, s.id sync_id
  FROM "${schema}".synchronization s
  WHERE s.mirrorTableName IS NOT NULL
);

INSERT INTO "${schema}".sequence_table_generator(SEQ_TABLE_NAME, SEQ_NEXT_VALUE) VALUES ('MIRROR_TABLE', (SELECT COALESCE(MAX(id), 0) + 1 FROM "${schema}".mirrorTable));

ALTER TABLE "${schema}".synchronization ADD COLUMN rotation CHARACTER VARYING(20) DEFAULT 'DISABLED' NOT NULL;
ALTER TABLE "${schema}".synchronization ADD COLUMN rotationGroup_id BIGINT;
ALTER TABLE "${schema}".synchronization ADD CONSTRAINT FK_ROTATION_ID FOREIGN KEY (rotationGroup_id) REFERENCES "${schema}".tableRotationGroup(id);
