DROP VIEW IF EXISTS "${schema}".activityLogView;
CREATE VIEW "${schema}".activityLogView AS
  SELECT
    al.id
    , al.synchronization
    , al.type
    , al.startedBy
    , al.scheduledStart
    , al.startDate
    , al.endDate
    , al.status
    , al.migrationStatus
    , al.insertedCount
    , al.updatedCount
    , al.deletedCount
    , al.totalToInsert
    , al.totalToUpdate
    , al.totalToDelete
    , (al.insertedCount + al.updatedCount + al.deletedCount) AS total
    , al.recordsCounted
    , al.totalKeysForDiff
    , al.keysForDiffDownloaded
    , EXTRACT(EPOCH FROM (al.endDate - al.startDate)) * 1000 AS duration
    , st.type as snowtableType
  FROM "${schema}".activityLog al
    JOIN "${schema}".synchronization sync ON al.synchronization = sync.id
    JOIN "${schema}".snowTable st         ON sync.snowtable_id = st.id;
